/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.offline;

import com.sothawo.mapjfx.offline.CachingHttpURLConnection;
import com.sothawo.mapjfx.offline.CachingHttpsURLConnection;
import com.sothawo.mapjfx.offline.OfflineCache;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    public static final String PROTO_HTTP = "http";
    public static final String PROTO_HTTPS = "https";
    private static final Logger logger = LoggerFactory.getLogger(CachingURLStreamHandlerFactory.class);
    private final OfflineCache cache;
    private final Map<String, URLStreamHandler> handlers = new ConcurrentHashMap<String, URLStreamHandler>();

    CachingURLStreamHandlerFactory(OfflineCache cache) {
        this.cache = cache;
        this.handlers.put(PROTO_HTTP, this.getURLStreamHandler(PROTO_HTTP));
        this.handlers.put(PROTO_HTTPS, this.getURLStreamHandler(PROTO_HTTPS));
    }

    private URLStreamHandler getURLStreamHandler(String protocol) {
        try {
            Method method = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
            method.setAccessible(true);
            return (URLStreamHandler)method.invoke(null, protocol);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("could not access URL.getUrlStreamHandler for protocol {}, {}", (Object)protocol, (Object)e.getMessage());
            }
            return null;
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        if (null == protocol) {
            throw new IllegalArgumentException("null protocol not allowed");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("need to create URLStreamHandler for protocol {}", (Object)protocol);
        }
        if (this.handlers.get(protocol) == null) {
            logger.warn("default protocol handler for protocol {} not available", (Object)protocol);
            return null;
        }
        final String proto = protocol.toLowerCase();
        if (PROTO_HTTP.equals(proto) || PROTO_HTTPS.equals(proto)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    if (logger.isTraceEnabled()) {
                        logger.trace("should open connection to {}", (Object)url.toExternalForm());
                    }
                    URLConnection defaultUrlConnection = new URL(protocol, url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)CachingURLStreamHandlerFactory.this.handlers.get(protocol)).openConnection();
                    if (!CachingURLStreamHandlerFactory.this.cache.urlShouldBeCached(url)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("not using cache for {}", (Object)url);
                        }
                        return defaultUrlConnection;
                    }
                    Path cacheFile = CachingURLStreamHandlerFactory.this.cache.filenameForURL(url);
                    if (CachingURLStreamHandlerFactory.this.cache.isCached(url)) {
                        return new CachingHttpURLConnection(CachingURLStreamHandlerFactory.this.cache, (HttpURLConnection)defaultUrlConnection);
                    }
                    switch (proto) {
                        case "http": {
                            return new CachingHttpURLConnection(CachingURLStreamHandlerFactory.this.cache, (HttpURLConnection)defaultUrlConnection);
                        }
                        case "https": {
                            return new CachingHttpsURLConnection(CachingURLStreamHandlerFactory.this.cache, (HttpsURLConnection)defaultUrlConnection);
                        }
                    }
                    throw new IOException("no matching handler");
                }

                @Override
                protected URLConnection openConnection(URL u, Proxy p) throws IOException {
                    if (logger.isTraceEnabled()) {
                        logger.trace("should open connection to {} via {}", (Object)u.toExternalForm(), (Object)p);
                    }
                    URLConnection defaultUrlConnection = new URL(protocol, u.getHost(), u.getPort(), u.getFile(), (URLStreamHandler)CachingURLStreamHandlerFactory.this.handlers.get(protocol)).openConnection(p);
                    return defaultUrlConnection;
                }
            };
        }
        return null;
    }
}

